﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    public class CityStateManager:BaseBO 
    {
        public string GetStateByID(int stateId)
        {
            using (_db = GetDataContext())
            {

                return (from s in _db.STD_STATEs where s.ID == stateId select s).SingleOrDefault().POSTALNAME ; 
            }

        }

        public string GetCountryByID(int countryId)
        {
            string country = string.Empty;

            using (_db = GetDataContext())
            {
                 STD_COUNTRY countryRecord = (from c in _db.STD_COUNTRies where c.ID == countryId select c).FirstOrDefault();

                if (countryRecord != null)
                {
                    country = countryRecord.SHORTNAME;
                }
            }

            return country;
        }

        public string GetCountyByID(int countyId)
        {
            using (_db = GetDataContext())
            {

                return (from c in _db.STD_COUNTies where c.ID == countyId select c).SingleOrDefault().NAME;
            }

        }
    }
}
